*****************************************************
// Selection Tables
*****************************************************
*Set polynomial order for each bandwidth
global apisbw2 
global apisbw5 X1
global apisbw10 X1 X2

global dhsbw2 X1
global dhsbw5 X1 X2
global dhsbw10 X1 X2 X3
global dhsbw15 X1 X2 X3

global cluster age
*Texfile
global texfile "$output/table_selection.tex"
global nvars 3
use "$data\apisfile", clear
fvset base 4 categ
label drop categ
label define categ 1 "Always-Takers"  2 "\shortstack[l]{Always-Takers \& \\ Treated Compliers}" 3 "\shortstack[l]{Never-Takers \& \\ Untreated Compliers}" 4 "Never-Takers"

* Create mock column
qui reg phicmem 
  est store fmock

* Estimate selection regression
global flist0 
	foreach b in  5  { 
		local fX ${apisbw`b'}
		foreach yvar in  lnpchealth    {	
				global name `yvar'`b'
				eststo $name: reg `yvar' i.categ D yr c.(`fX') i.D#c.(`fX') if inrange(X1, -`b', `b'-1), cluster(hhid) 
					 estadd ysumm
					 sum `yvar' if categ==4 & e(sample)==1
					 estadd local controlmean=string(`r(mean)', "%9.3f")
					 estadd local poly= wordcount("`fX'")
					 estadd local controls "Age \& Year"

				reg `yvar' i.categ D yr c.(`fX') i.D#c.(`fX') if inrange(X1, -`b', `b'-1), cluster($cluster) 
					 do "$code\boottest_output"
					 test 1.categ=2.categ					 
					 global flist0 ${flist0} `yvar'`b'
					
	
					
		}
	} 
	
use "$data\ndhsfile", clear
fvset base 4 categ
label drop categ
label define categ 1 "Always-Takers"  2 "\shortstack[l]{Always-Takers \& \\ Treated Compliers}" 3 "\shortstack[l]{Never-Takers \& \\ Untreated Compliers}" 4 "Never-Takers"
	
	foreach b in  5    { 
		local fX ${dhsbw`b'}
		
		foreach yvar in yconfined mvisit      {
				global name `yvar'`b'
				eststo $name: reg `yvar' i.categ D yr c.(`fX') i.D#c.(`fX') if inrange(X1, -`b', `b'-1), cluster(hhid) 
					 estadd ysumm
					 sum `yvar' if categ==4 & e(sample)==1
					 estadd local controlmean=string(`r(mean)', "%9.3f"	)				
					 estadd local poly= wordcount("`fX'")
					 estadd local controls "Age \& Year"
					 
				reg `yvar' i.categ D yr c.(`fX') i.D#c.(`fX') if inrange(X1, -`b', `b'-1), cluster($cluster)				 
					
					 do "$code\boottest_output"
					 test 1.categ=2.categ
					 global flist0 ${flist0} `yvar'`b'

		}
			
	} 
	
* Capture column-wise scalars
 

* Print table in latex 
local latex_opt_top  ///  
	prehead( ///
		"\begin{tabular}{l*{@M}{rr}}" ///
		"\hline" ///
		"\hline" ///
		) ///
	posthead( ///
		" & \multicolumn{1}{c}{\shortstack{Log Health\\Expenditures\\(APIS)}} & \multicolumn{1}{c}{\shortstack{Hospital Stay\\Last Year\\(DHS)}} & \multicolumn{1}{c}{\shortstack{Health Visit\\Last Month\\(DHS)}} \\" ///
		 "\hline" ///
		"\hline" ///
		"& \multicolumn{@M}{c}{} \\" ///
		)
local latex_opt_end  ///
	prefoot( ///
		"\hline" ///
		) ///
	postfoot( ///
		"\hline" ///
		"\end{tabular}" ///
		)
local labopt_est  keep(*categ) drop(4.categ) cells(b(fmt(a2)) se(star fmt(a2) par) boot_pval( fmt(2) par([ ])))  ///
  collabels(none) varw(25) style(tex) label
local labopt_est0 mlabel(none) `latex_opt_top' replace 
local labopt_estX mlabel(none) append
local labopt_fin  mlabel(none) collabels(none) modelw(15) varw(25) style(tex) `latex_opt_end' append

esttab $flist0 using "$texfile", `labopt_est' `labopt_est0' varlabel(phicmem "Enrolled in PHIC") starlevels(* 0.1 ** 0.05 *** 0.01) nonumbers noobs ///
	scalars("poly Polynomial Order" "controlmean Never-Taker Dep. Var Mean" "N \$ N\$") `latex_opt_end'

*estout matrix(stats, fmt(a2)) using "$texfile", `labopt_fin' 
global nvars 2